#!/sbin/sh
configValue="$1"
nikgapps_config_file_name="$2"
install_partition="$3"

make_dir() {
  addToLog "- Creating Directory: $install_partition/$1" "$package_title"
  mkdir -p "$install_partition/$1"
  set_perm 1000 1000 0755 "$install_partition/$1"
}
# Initialize the variables
default_partition="product"
clean_flash_only="false"
product_prefix=$(find_product_prefix "$install_partition")
title="GoogleDuo"
package_title="GoogleDuo"
pkg_size="53520"
package_name="com.google.android.apps.tachyon"
packagePath=installGoogleDuoFiles
deleteFilesPath=deleteGoogleDuoFiles
propFilePath=$(get_prop_file_path $package_title)

remove_aosp_apps_from_rom="
"

delete_overlays="
"

file_list="
___app___GoogleDuo___lib___arm64/libcronet.96.0.4664.17.so
___app___GoogleDuo___lib___arm64/libsketchology_native.so
___app___GoogleDuo___lib___arm64/libfilterframework_jni.so
___app___GoogleDuo___lib___arm64/libjingle_peerconnection_so.so
___app___GoogleDuo/split_config.en.apk
___app___GoogleDuo/GoogleDuo.apk
___app___GoogleDuo/split_config.xxhdpi.apk
___app___GoogleDuo/split_config.arm64_v8a.apk
"

remove_overlays() {
   for i in $delete_overlays; do
       delete_overlays "$i" "$propFilePath" "$package_title" 
   done
}

remove_existing_package() {
   # remove the existing folder for clean install of GoogleDuo
   delete_package "GoogleDuo" "$package_title" 
}

remove_aosp_apps() {
   # Delete the folders that we want to remove with installing GoogleDuo
   for i in $remove_aosp_apps_from_rom; do
       RemoveAospAppsFromRom "$i" "$propFilePath" "$package_title" 
   done
}

install_package() {
   remove_existing_package
   remove_aosp_apps
   remove_overlays
   # Create folders and set the permissions
   make_dir "app"
   make_dir "app/GoogleDuo"
   make_dir "app/GoogleDuo/lib"
   make_dir "app/GoogleDuo/lib/arm64"

   delete_prop_lines "$propFilePath"

   # Copy the files and set the permissions
   for i in $file_list; do
       install_file "$i"
   done

   chmod 755 "$COMMONDIR/addon";
   update_prop "$propFilePath" "install" "$propFilePath" "GoogleDuo" 
   . $COMMONDIR/addon "GoogleDuo" "$propFilePath" "09"
   copy_file "$propFilePath" "$logDir/addonfiles/$package_title.prop"
}

find_install_mode

