#!/sbin/sh

uninstall_package() {
    # Remove the files when we're uninstalling NiKGapps
    for i in $file_list; do
        uninstall_file "$i" "$package_title"
    done
    # Removing the addon sh so it doesn't get backed up and restored
    for i in $(find /system/addon.d -iname "*$package_title.sh" 2>/dev/null;); do
      if [ -f "$i" ]; then
        addToLog "- Removing $i" "$package_title"
        rm -rf "$i"
      fi
    done
    # Removing the updates and residue
    if [ -n "$2" ]; then
        for i in $(find /data -iname "*$2*" 2>/dev/null); do
            if [ -e "$i" ] || [ -d "$1"]; then
                addToLog "- contents matching $2 found at $i"
                rm -rf "$i"
            fi
        done
    fi
}

# Initialize the variables
clean_flash_only="false"
title="GoogleDuo"
package_title="GoogleDuo"
package_name="com.google.android.apps.tachyon"

file_list="
___app___GoogleDuo___lib___arm64/libcronet.96.0.4664.17.so
___app___GoogleDuo___lib___arm64/libsketchology_native.so
___app___GoogleDuo___lib___arm64/libfilterframework_jni.so
___app___GoogleDuo___lib___arm64/libjingle_peerconnection_so.so
___app___GoogleDuo/split_config.en.apk
___app___GoogleDuo/GoogleDuo.apk
___app___GoogleDuo/split_config.xxhdpi.apk
___app___GoogleDuo/split_config.arm64_v8a.apk
"

uninstall_package
