#!/sbin/sh
configValue="$1"
nikgapps_config_file_name="$2"
install_partition="$3"

make_dir() {
  addToLog "- Creating Directory: $install_partition/$1" "$package_title"
  mkdir -p "$install_partition/$1"
  set_perm 1000 1000 0755 "$install_partition/$1"
}
# Initialize the variables
default_partition="product"
clean_flash_only="false"
product_prefix=$(find_product_prefix "$install_partition")
title="Chrome-Stub"
package_title="GoogleChrome"
pkg_size="17465"
package_name="com.android.chrome"
packagePath=installGoogleChromeFiles
deleteFilesPath=deleteGoogleChromeFiles
propFilePath=$(get_prop_file_path $package_title)

remove_aosp_apps_from_rom="
Bolt
Browser
Browser2
BrowserIntl
BrowserProviderProxy
Chromium
DuckDuckGo
Fluxion
Gello
Jelly
PA_Browser
PABrowser
YuBrowser
BLUOpera
BLUOperaPreinstall
ViaBrowser
Duckduckgo
"

delete_overlays="
"

file_list="
___app___Chrome/Chrome.apk.gz
___app___Chrome-Stub/Chrome-Stub.apk
"

remove_overlays() {
   for i in $delete_overlays; do
       delete_overlays "$i" "$propFilePath" "$package_title" 
   done
}

remove_existing_package() {
   # remove the existing folder for clean install of GoogleChrome
   delete_package "Chrome-Stub" "$package_title" 
}

remove_aosp_apps() {
   # Delete the folders that we want to remove with installing GoogleChrome
   for i in $remove_aosp_apps_from_rom; do
       RemoveAospAppsFromRom "$i" "$propFilePath" "$package_title" 
   done
}

install_package() {
   remove_existing_package
   remove_aosp_apps
   remove_overlays
   # Create folders and set the permissions
   make_dir "app"
   make_dir "app/Chrome"
   make_dir "app/Chrome-Stub"

   delete_prop_lines "$propFilePath"

   # Copy the files and set the permissions
   for i in $file_list; do
       install_file "$i"
   done

   chmod 755 "$COMMONDIR/addon";
   update_prop "$propFilePath" "install" "$propFilePath" "GoogleChrome" 
   . $COMMONDIR/addon "GoogleChrome" "$propFilePath" "09"
   copy_file "$propFilePath" "$logDir/addonfiles/$package_title.prop"
}

find_install_mode

