#!/sbin/sh
configValue="$1"
nikgapps_config_file_name="$2"
install_partition="$3"

make_dir() {
  addToLog "- Creating Directory: $install_partition/$1" "$package_title"
  mkdir -p "$install_partition/$1"
  set_perm 1000 1000 0755 "$install_partition/$1"
}
# Initialize the variables
default_partition="product"
clean_flash_only="false"
product_prefix=$(find_product_prefix "$install_partition")
title="PrebuiltGmsCoreSc"
package_title="GmsCore"
pkg_size="167813"
package_name="com.google.android.gms"
packagePath=installGmsCoreFiles
deleteFilesPath=deleteGmsCoreFiles
propFilePath=$(get_prop_file_path $package_title)

remove_aosp_apps_from_rom="
PrebuiltGmsCoreQt
PrebuiltGmsCoreRvc
GmsCore
"

delete_overlays="
"

file_list="
___priv-app___PrebuiltGmsCore___app_chimera___m/PrebuiltGmsCoreSc_CronetDynamite.apk
___priv-app___PrebuiltGmsCore___app_chimera___m/PrebuiltGmsCoreSc_MeasurementDynamite.apk
___priv-app___PrebuiltGmsCore___app_chimera___m/PrebuiltGmsCoreSc_DynamiteModulesA.apk
___priv-app___PrebuiltGmsCore___app_chimera___m/PrebuiltGmsCoreSc_DynamiteModulesC.apk
___priv-app___PrebuiltGmsCore___app_chimera___m/PrebuiltGmsCoreSc_MapsDynamite.apk
___priv-app___PrebuiltGmsCore___app_chimera___m/PrebuiltGmsCoreSc_AdsDynamite.apk
___priv-app___PrebuiltGmsCore___app_chimera___m/PrebuiltGmsCoreSc_GoogleCertificates.apk
___priv-app___PrebuiltGmsCore___app_chimera___m/PrebuiltGmsCoreSc_DynamiteLoader.apk
___priv-app___PrebuiltGmsCore/PrebuiltGmsCoreSc.apk
___overlay/GmsCoreOverlay.apk
___priv-app___PrebuiltGmsCore___m___independent/AndroidPlatformServices.apk
___priv-app___PrebuiltGmsCore___m___optional/MlkitBarcodeUIPrebuilt.apk
___priv-app___PrebuiltGmsCore___m___optional/VisionBarcodePrebuilt.apk
___etc___permissions/com.google.android.gms.xml
"

remove_overlays() {
   for i in $delete_overlays; do
       delete_overlays "$i" "$propFilePath" "$package_title" 
   done
}

remove_existing_package() {
   # remove the existing folder for clean install of GmsCore
   delete_package "PrebuiltGmsCoreSc" "$package_title" 
}

remove_aosp_apps() {
   # Delete the folders that we want to remove with installing GmsCore
   for i in $remove_aosp_apps_from_rom; do
       RemoveAospAppsFromRom "$i" "$propFilePath" "$package_title" 
   done
}

install_package() {
   remove_existing_package
   remove_aosp_apps
   remove_overlays
   # Create folders and set the permissions
   make_dir "priv-app/PrebuiltGmsCore"
   make_dir "priv-app/PrebuiltGmsCore/app_chimera"
   make_dir "priv-app/PrebuiltGmsCore/app_chimera/m"
   make_dir "priv-app/PrebuiltGmsCore/m"
   make_dir "priv-app/PrebuiltGmsCore/m/independent"
   make_dir "priv-app/PrebuiltGmsCore/m/optional"

   delete_prop_lines "$propFilePath"

   # Copy the files and set the permissions
   for i in $file_list; do
       install_file "$i"
   done


gms_optimization=$(ReadConfigValue "gms_optimization" "$nikgapps_config_file_name")
[ -z "$gms_optimization" ] && gms_optimization=0
if [ "$gms_optimization" = "1" ]; then
    sed -i '/allow-in-power-save package="com.google.android.gms"/d' $install_partition/etc/permissions/*.xml
    sed -i '/allow-in-data-usage-save package="com.google.android.gms"/d' $install_partition/etc/permissions/*.xml
    sed -i '/allow-unthrottled-location package="com.google.android.gms"/d' $install_partition/etc/permissions/*.xml
    sed -i '/allow-ignore-location-settings package="com.google.android.gms"/d' $install_partition/etc/permissions/*.xml
    addToLog "- Battery Optimization Done in $install_partition/etc/permissions/*.xml!" "$package_title"
    sed -i '/allow-in-power-save package="com.google.android.gms"/d' $install_partition/etc/sysconfig/*.xml
    sed -i '/allow-in-data-usage-save package="com.google.android.gms"/d' $install_partition/etc/sysconfig/*.xml
    sed -i '/allow-unthrottled-location package="com.google.android.gms"/d' $install_partition/etc/sysconfig/*.xml
    sed -i '/allow-ignore-location-settings package="com.google.android.gms"/d' $install_partition/etc/sysconfig/*.xml
    addToLog "- Battery Optimization Done in $install_partition/etc/sysconfig/*.xml!" "$package_title"
else
    addToLog "- Battery Optimization not Enabled" "$package_title"
fi
            
   chmod 755 "$COMMONDIR/addon";
   update_prop "$propFilePath" "install" "$propFilePath" "GmsCore" 
   . $COMMONDIR/addon "GmsCore" "$propFilePath" "05"
   copy_file "$propFilePath" "$logDir/addonfiles/$package_title.prop"
}

find_install_mode

