#!/sbin/sh
configValue="$1"
nikgapps_config_file_name="$2"
install_partition="$3"

make_dir() {
  addToLog "- Creating Directory: $install_partition/$1" "$package_title"
  mkdir -p "$install_partition/$1"
  set_perm 1000 1000 0755 "$install_partition/$1"
}
# Initialize the variables
default_partition="product"
clean_flash_only="false"
product_prefix=$(find_product_prefix "$install_partition")
title="WebViewGoogle-Stub"
package_title="WebViewGoogle"
pkg_size="43298"
package_name="com.google.android.webview"
packagePath=installWebViewGoogleFiles
deleteFilesPath=deleteWebViewGoogleFiles
propFilePath=$(get_prop_file_path $package_title)

remove_aosp_apps_from_rom="
webview
"

delete_overlays="
"

file_list="
___app___WebViewGoogle/WebViewGoogle.apk.gz
___overlay/GoogleWebViewOverlay.apk
___app___WebViewGoogle-Stub/WebViewGoogle-Stub.apk
"

remove_overlays() {
   for i in $delete_overlays; do
       delete_overlays "$i" "$propFilePath" "$package_title" 
   done
}

remove_existing_package() {
   # remove the existing folder for clean install of WebViewGoogle
   delete_package "WebViewGoogle-Stub" "$package_title" 
}

remove_aosp_apps() {
   # Delete the folders that we want to remove with installing WebViewGoogle
   for i in $remove_aosp_apps_from_rom; do
       RemoveAospAppsFromRom "$i" "$propFilePath" "$package_title" 
   done
}

install_package() {
   remove_existing_package
   remove_aosp_apps
   remove_overlays
   # Create folders and set the permissions
   make_dir "app"
   make_dir "app/WebViewGoogle"
   make_dir "app/WebViewGoogle-Stub"

   delete_prop_lines "$propFilePath"

   # Copy the files and set the permissions
   for i in $file_list; do
       install_file "$i"
   done

   chmod 755 "$COMMONDIR/addon";
   update_prop "$propFilePath" "install" "$propFilePath" "WebViewGoogle" 
   . $COMMONDIR/addon "WebViewGoogle" "$propFilePath" "09"
   copy_file "$propFilePath" "$logDir/addonfiles/$package_title.prop"
}

find_install_mode

