#!/sbin/sh
configValue="$1"
nikgapps_config_file_name="$2"
install_partition="$3"

make_dir() {
  addToLog "- Creating Directory: $install_partition/$1" "$package_title"
  mkdir -p "$install_partition/$1"
  set_perm 1000 1000 0755 "$install_partition/$1"
}
# Initialize the variables
default_partition="product"
clean_flash_only="false"
product_prefix=$(find_product_prefix "$install_partition")
title="PixelWallpapers2022"
package_title="PixelWallpapers2022"
pkg_size="54880"
package_name="com.google.android.apps.wallpaper.pixel"
packagePath=installPixelWallpapers2022Files
deleteFilesPath=deletePixelWallpapers2022Files
propFilePath=$(get_prop_file_path $package_title)

remove_aosp_apps_from_rom="
"

delete_overlays="
"

file_list="
___app___PixelWallpapers2022/PixelWallpapers2022.apk
"

remove_overlays() {
   for i in $delete_overlays; do
       delete_overlays "$i" "$propFilePath" "$package_title" 
   done
}

remove_existing_package() {
   # remove the existing folder for clean install of PixelWallpapers2022
   delete_package "PixelWallpapers2022" "$package_title" 
}

remove_aosp_apps() {
   # Delete the folders that we want to remove with installing PixelWallpapers2022
   for i in $remove_aosp_apps_from_rom; do
       RemoveAospAppsFromRom "$i" "$propFilePath" "$package_title" 
   done
}

install_package() {
   remove_existing_package
   remove_aosp_apps
   remove_overlays
   # Create folders and set the permissions
   make_dir "app"
   make_dir "app/PixelWallpapers2022"

   delete_prop_lines "$propFilePath"

   # Copy the files and set the permissions
   for i in $file_list; do
       install_file "$i"
   done

   chmod 755 "$COMMONDIR/addon";
   update_prop "$propFilePath" "install" "$propFilePath" "PixelWallpapers2022" 
   . $COMMONDIR/addon "PixelWallpapers2022" "$propFilePath" "09"
   copy_file "$propFilePath" "$logDir/addonfiles/$package_title.prop"
}

find_install_mode

